<?php

namespace App\Http\Controllers;

use App\Models\AddType;
use Illuminate\Http\Request;

class AddTypeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $querylogs=AddType::where('status', 1)->orderBy('id', 'ASC')->get();
        return view('ads-type.index',compact('querylogs'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('ads-type.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|unique:add_types|max:255',
        ]);
        AddType::create($request->all());
        return redirect()->route('add_type.index')->with('success','Added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\AddType  $addType
     * @return \Illuminate\Http\Response
     */
    public function show(AddType $addType)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\AddType  $addType
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $ads = AddType::find($id);
        return view('ads-type.edit',compact('ads'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\AddType  $addType
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,$id)
    {
        $update = AddType::find($id);
        $update->update($request->all());
        return redirect()->route('add_type.edit',$id)->with('success','Updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\AddType  $addType
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $delete = AddType::find($id)->delete();
        return redirect()->route('add_type.index')->with('success','Deleted successfully');
    }
}
