<?php

namespace App\Http\Controllers;

use Image;
use App\Models\Ads;
use App\Models\AddType;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class AdsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $querylogs=Ads::orderBy('id', 'ASC')->get();
        return view('ads.index',compact('querylogs'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $AddType=AddType::where('status', 1)->orderBy('id', 'ASC')->get();
        return view('ads.create',compact('AddType'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'image' => 'required',
        ]);
        $input = $request->all();
        $user_name = Str::slug($request->type_id , '-') .'-'. Str::random(5);
        if ($request->hasFile('image')) {
            $name = $request->file('image')->getClientOriginalName();
            $extension = $request->file('image')->extension();
            $path = Storage::Disk('public')->putFileAs( 'ads_images', $request->file('image'), $user_name.'.'.$extension);
            $img = Image::make($request->file('image'));
            $img->save(public_path('/ads_images/'.$user_name.'.'.$extension));
            $photo = $user_name.'.'.$extension;
            $input['image'] = $photo;
        }
        $AddType=AddType::where('id', $request->type_id)->first();
        $input['type_name'] = $AddType->name;
        $adds= Ads::create($input);
        return redirect()->route('ads.index')->with('success','Added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Ads  $ads
     * @return \Illuminate\Http\Response
     */
    public function show(Ads $ads)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Ads  $ads
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $ads = Ads::find($id);
        $AddType=AddType::where('status', 1)->orderBy('id', 'ASC')->get();
        return view('ads.edit',compact('ads','AddType'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Ads  $ads
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $update = Ads::find($id);
        $input = $request->all();
        $user_name = Str::slug($request->type_id , '-') .'-'. Str::random(5);
        if ($request->hasFile('image')) {
            $name = $request->file('image')->getClientOriginalName();
            $extension = $request->file('image')->extension();
            $path = Storage::Disk('public')->putFileAs( 'ads_images', $request->file('image'), $user_name.'.'.$extension);
            $img = Image::make($request->file('image'));
            $img->save(public_path('/ads_images/'.$user_name.'.'.$extension));
            $photo = $user_name.'.'.$extension;
            $input['image'] = $photo;
        }
        $AddType=AddType::where('id', $request->type_id)->first();
        $input['type_name'] = $AddType->name;
        $update->update($input);
        return redirect()->route('ads.edit',$id)->with('success','Updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Ads  $ads
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $delete = Ads::find($id)->delete();
        return redirect()->route('ads.index')->with('success','Deleted successfully');
    }
}
