@extends('layouts.backend')
@section('content')

<div class="col-xl-12 col-lg-12 col-sm-12  layout-spacing">
    <a href="{{ URL::previous() }}" class="btn btn-danger mb-2 mr-2">
        Go back
    </a>
    <h4>Update Ad</h4>
    <form action="{!! route('ads.update',$ads->id) !!}" method="post" enctype="multipart/form-data">
        @csrf
        @method('PUT')
        <div class="widget-content widget-content-area br-6">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            <div class="table-responsive mb-2 mt-2"><label for="">Select Ad Position</label>
                <div class="row">
                    @foreach($AddType as $type)
                    <div class="col-md-3">
                        <input type="radio" name="type_id" value="{{ $type->id }}" {{ ( $type->id == $ads->type_id ? 'checked' : '') }}>
                        <label for="myCheck">{{ $type->name }}</label>
                    </div>
                    @endforeach
                </div>
                <div class="row">
                    <div class="col-md-4">
                        <label for="">Start Date</label>
                        <input type="text" class="form-control mb-3" id="my_date_picker" name="start_date" required value="{{ $ads->start_date }}">
                    </div>
                    <div class="col-md-4">
                        <label for="">End Date</label>
                        <input type="text" class="form-control mb-3" id="my_date_picker1" name="end_date" required value="{{ $ads->end_date }}">
                    </div>
                    <div class="col-md-4">
                        <label for="">Upload Poster</label>
                        <input type="file" class="form-control mb-3" name="image" value="">
                    </div>
                    <div class="col-md-4">
                        <label for="">External Link</label>
                        <input type="text" class="form-control mb-3" name="url_link" required value="{{ $ads->url_link }}">
                    </div>
                    <div class="col-md-4">
                        <label for="">Button Text</label>
                        <input type="text" class="form-control mb-3" name="button_text" required value="{{ $ads->button_text }}">
                    </div>
                </div>
            </div>
            <div class="table-responsive"><button type="submit" class="btn btn-primary" name="button">Publish</button>
            </div>
        </div>
    </form>
</div>
@endsection
